-- new script file
-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true

    if not self.loaded then
      self.defCount = 0
      self.counted = false
      self.deactivate = false
    end
    
    self.allKilled:LinkToTarget("defendersKilled")
  end
  
  if self.counted and not self.deactivate then
    if self.defCount == 0 then
      self.allKilled:TriggerAllTargets()
      self.deactivate = true
    end
  end
end

function OnTrigger(self, sourceName, targetName)
  if targetName == "defenderCounted" then
    self.defCount = self.defCount + 1
    self.counted = true
  elseif targetName == "defenderKilled" then
    self.defCount = self.defCount - 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.defCount = ar:Read()
    self.counted = ar:Read()
    self.deactivate = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.defCount)
    ar:Write(self.counted)
    ar:Write(self.deactivate)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("defenderCounted")
  self:AddTriggerTarget("defenderKilled")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("allKilled")
end
